# -*- coding: utf-8 -*-
"""
boundary.py

Boundary projector 𝓑: keep only ±N boundary entries, zero interior.
Idempotent, linear, with explicit edge policy documented below.

Policy: 'keep' ⇒ new[0]=old[0], new[-1]=old[-1], interior=0.
"""
from __future__ import annotations
import numpy as np
from .tick_state import TickState

def B(state: TickState) -> TickState:
    dist = state.distribution
    out = np.zeros_like(dist)
    if dist.size == 1:
        out[0] = dist[0]
    elif dist.size >= 2:
        out[0]  = dist[0]
        out[-1] = dist[-1]
    return TickState(out, state.N)
